/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.gui;

import Krasnodar.rockstarnew.framework.base.CustomComponent;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.systems.setting.Setting;
import Krasnodar.rockstarnew.systems.setting.settings.BezierSetting;
import Krasnodar.rockstarnew.systems.setting.settings.BindSetting;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.systems.setting.settings.ButtonSetting;
import Krasnodar.rockstarnew.systems.setting.settings.ColorSetting;
import Krasnodar.rockstarnew.systems.setting.settings.ModeSetting;
import Krasnodar.rockstarnew.systems.setting.settings.RangeSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SelectSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SliderSetting;
import Krasnodar.rockstarnew.systems.setting.settings.StringSetting;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.MenuSettingComponent;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.BezierSettingComponent;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.BindSettingComponent;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.BooleanSettingComponent;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.ButtonSettingComponent;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.ColorSettingComponent;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.ModeSettingComponent;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.RangeSettingComponent;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.SelectSettingComponent;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.SliderSettingComponent;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.StringSettingComponent;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import Krasnodar.rockstarnew.utility.interfaces.IScaledResolution;
import Krasnodar.rockstarnew.utility.render.obj.Rect;
import lombok.Generated;
import net.minecraft.class_5611;

public final class GuiUtility {
    public static float getMiddleOfBox(float objectHeight, float boxHeight) {
        return (float)Math.ceil(boxHeight / 2.0f - objectHeight / 2.0f);
    }

    public static double getMiddleOfBox(double objectHeight, double boxHeight) {
        return Math.ceil(boxHeight / 2.0 - objectHeight / 2.0);
    }

    public static boolean isHovered(double x, double y, double width, double height, int mouseX, int mouseY) {
        return (double)mouseX >= x && (double)mouseX < x + width && (double)mouseY >= y && (double)mouseY < y + height;
    }

    public static boolean isHovered(double x, double y, double width, double height, UIContext context) {
        return GuiUtility.isHovered(x, y, width, height, context.getMouseX(), context.getMouseY());
    }

    public static boolean isHovered(Rect rect, double mouseX, double mouseY) {
        return GuiUtility.isHovered((double)rect.getX(), (double)rect.getY(), (double)rect.getWidth(), (double)rect.getHeight(), mouseX, mouseY);
    }

    public static boolean isHovered(CustomComponent rect, double mouseX, double mouseY) {
        return GuiUtility.isHovered((double)rect.getX(), (double)rect.getY(), (double)rect.getWidth(), (double)rect.getHeight(), mouseX, mouseY);
    }

    public static boolean isHovered(double x, double y, double width, double height, double mouseX, double mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static float getSliderValue(float min, float max, float start, float size, double mouse) {
        return (float)(Math.min(1.0, Math.max(0.0, (mouse - (double)start) / (double)size)) * (double)(max - min)) + min;
    }

    public static float getSliderValueWithoutClamp(float min, float max, float start, float size, double mouse) {
        return (float)((mouse - (double)start) / (double)size * (double)(max - min)) + min;
    }

    public static float getPercent(float value, float min, float max) {
        return (value - min) / (max - min);
    }

    public static class_5611 getMouse() {
        return new class_5611((float)(IMinecraft.mc.field_1729.method_1603() / IScaledResolution.sr.getScaleFactor()), (float)(IMinecraft.mc.field_1729.method_1604() / IScaledResolution.sr.getScaleFactor()));
    }

    public static MenuSettingComponent settinge(Setting setting, CustomComponent parent) {
        MenuSettingComponent settingComponent = null;
        if (setting instanceof BooleanSetting) {
            BooleanSetting s = (BooleanSetting)setting;
            settingComponent = new BooleanSettingComponent(s, parent);
        } else if (setting instanceof BindSetting) {
            BindSetting s = (BindSetting)setting;
            settingComponent = new BindSettingComponent(s, parent);
        } else if (setting instanceof ColorSetting) {
            ColorSetting s = (ColorSetting)setting;
            settingComponent = new ColorSettingComponent(s, parent);
        } else if (setting instanceof ModeSetting) {
            ModeSetting s = (ModeSetting)setting;
            settingComponent = new ModeSettingComponent(s, parent);
        } else if (setting instanceof RangeSetting) {
            RangeSetting s = (RangeSetting)setting;
            settingComponent = new RangeSettingComponent(s, parent);
        } else if (setting instanceof BezierSetting) {
            BezierSetting s = (BezierSetting)setting;
            settingComponent = new BezierSettingComponent(s, parent);
        } else if (setting instanceof ButtonSetting) {
            ButtonSetting s = (ButtonSetting)setting;
            settingComponent = new ButtonSettingComponent(s, parent);
        } else if (setting instanceof SelectSetting) {
            SelectSetting s = (SelectSetting)setting;
            settingComponent = new SelectSettingComponent(s, parent);
        } else if (setting instanceof SliderSetting) {
            SliderSetting s = (SliderSetting)setting;
            settingComponent = new SliderSettingComponent(s, parent);
        } else if (setting instanceof StringSetting) {
            StringSetting s = (StringSetting)setting;
            settingComponent = new StringSettingComponent(s, parent);
        }
        if (settingComponent != null) {
            settingComponent.onInit();
        }
        return settingComponent;
    }

    @Generated
    private GuiUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

